package furny.ga;

import java.util.ArrayList;
import java.util.Collection;

import furny.entities.Furniture;

/**
 * This is a list for furniture entries.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public class FurnEntryList extends ArrayList<FurnEntry> {
  private static final long serialVersionUID = -1050268562501172815L;

  /**
   * Creates a list and copies furniture entries from the given list.
   * 
   * @param c
   *          List to copy.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public FurnEntryList(final Collection<FurnEntry> c) {
    super(c);
  }

  /**
   * Creates an empty list.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public FurnEntryList() {

  }

  /**
   * Searches all furniture entries for the given furniture.
   * 
   * @param f
   *          The furniture to search.
   * @return <code>true</code>, if contained.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public boolean containsFurniture(final Furniture f) {
    for (final FurnEntry fe : this) {
      if (fe.getFurniture().equals(f)) {
        return true;
      }
    }
    return false;
  }

  /**
   * Getter for all furniture entries with the given furniture.
   * 
   * @param f
   *          The furniture to search.
   * @return The list of furniture entries containing the furniture.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public FurnEntryList getEntries(final Furniture f) {
    final FurnEntryList list = new FurnEntryList();

    for (final FurnEntry fe : this) {
      if (fe.getFurniture().equals(f)) {
        list.add(fe);
      }
    }

    return list;
  }

  @Override
  public FurnEntryList clone() {
    return new FurnEntryList(this);
  }
}
